package edu.unl.consystlab.sudokuSolver;

import java.awt.Color;
import java.util.*;
public class extraRegionsCells {
	private static extraRegionsCells uniqueInstance = new extraRegionsCells();
	private int [][] board;
	private Map colorMap = new HashMap();
	private extraRegionsCells(){
		initRegionColor();
		colorMap.put("WHITE", 0);
		colorMap.put("GRAY", 1);
		colorMap.put("LIGHT_GRAY", 2);
		colorMap.put("GREEN", 3);
		colorMap.put("YELLOW", 4);
		colorMap.put("PINK", 5);
		colorMap.put("CYAN", 6);
		colorMap.put("MAGENTA", 7);
		colorMap.put("ORANGE", 8);
		colorMap.put("RED", 9);
	};

	public static extraRegionsCells getInstance() {
		return uniqueInstance;
	}

	public int getRegionColor(String index){
		String [] indexArray = index.split(",");
		int row = Integer.parseInt(indexArray[0]);
		int column = Integer.parseInt(indexArray[1]);
		return board[row-1][column-1];
	}

	public void initRegionColor() {
		board = null;
		int [][] newBoard = {
				{0,0,0,0,0,0,0,0,0},
				{0,0,0,0,0,0,0,0,0},
				{0,0,0,0,0,0,0,0,0},
				{0,0,0,0,0,0,0,0,0},
				{0,0,0,0,0,0,0,0,0},
				{0,0,0,0,0,0,0,0,0},
				{0,0,0,0,0,0,0,0,0},
				{0,0,0,0,0,0,0,0,0},
				{0,0,0,0,0,0,0,0,0},
		};
		board = newBoard;
	}

	public void setCellValue(String index, String color) {
		String [] indexArray = index.split(",");
		int row = Integer.parseInt(indexArray[0]);
		int column = Integer.parseInt(indexArray[1]);
		board[row-1][column-1] = (Integer)colorMap.get(color);
	}

}